/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.gui.events;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.align.StructurePairAligner;
import org.biojava.bio.structure.gui.BiojavaJmol;
import org.biojava.bio.structure.gui.events.AlignmentPositionListener;
import org.biojava.bio.structure.gui.util.AlignedPosition;

public class JmolAlignedPositionListener
implements AlignmentPositionListener {
    BiojavaJmol parent;
    Atom[] ca1;
    Atom[] ca2;
    StructurePairAligner structurePairAligner;

    public JmolAlignedPositionListener(BiojavaJmol parent, StructurePairAligner alig) {
        this.parent = parent;
        this.structurePairAligner = alig;
    }

    public void setStructure1(Structure structure1) {
        this.ca1 = this.structurePairAligner.getAlignmentAtoms(structure1);
    }

    public void setStructure2(Structure structure2) {
        this.ca2 = this.structurePairAligner.getAlignmentAtoms(structure2);
    }

    public void mouseOverPosition(AlignedPosition p) {
        Chain c;
        Group parent;
        Atom a;
        int p1 = p.getPos1();
        int p2 = p.getPos2();
        String s = "select ";
        if (p1 > this.ca1.length || p2 > this.ca2.length) {
            System.err.println("requsting atom out of bounds! ");
            return;
        }
        String pdbpos1 = "";
        String pdbpos2 = "";
        if (p1 > -1) {
            a = this.ca1[p1];
            parent = a.getParent();
            c = parent.getParent();
            pdbpos1 = parent.getPDBCode();
            if (!c.getName().equals(" ")) {
                pdbpos1 = pdbpos1 + ":" + c.getName();
            }
            s = s + pdbpos1 + "/1";
        }
        if (p2 > -1) {
            a = this.ca2[p2];
            parent = a.getParent();
            c = parent.getParent();
            pdbpos2 = parent.getPDBCode();
            if (!c.getName().equals(" ")) {
                pdbpos2 = pdbpos2 + ":" + c.getName();
            }
            if (p1 > -1) {
                s = s + ",";
            }
            s = s + pdbpos2 + "/2";
        }
        s = s + "; set display selected;";
        this.parent.evalString(s);
    }

    public void positionSelected(AlignedPosition p) {
        this.mouseOverPosition(p);
    }

    public void rangeSelected(AlignedPosition start, AlignedPosition end) {
    }

    public void selectionLocked() {
    }

    public void selectionUnlocked() {
    }
}

