/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.gui.util;

import java.util.logging.Logger;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.align.ClusterAltAligs;
import org.biojava.bio.structure.align.StructurePairAligner;
import org.biojava.bio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.bio.structure.gui.AlignmentGui;
import org.biojava.bio.structure.gui.util.AlternativeAlignmentFrame;

public class AlignmentCalc
implements Runnable {
    public static Logger logger = Logger.getLogger("org.biojava");
    boolean interrupted = false;
    String pdb1;
    String pdb2;
    String chain1;
    String chain2;
    Structure structure1;
    Structure structure2;
    AlignmentGui parent;

    public AlignmentCalc(AlignmentGui parent, Structure s1, Structure s2) {
        this.parent = parent;
        this.structure1 = s1;
        this.structure2 = s2;
    }

    public void run() {
        StructurePairAligner aligner = new StructurePairAligner();
        aligner.setDebug(true);
        try {
            aligner.align(this.structure1, this.structure2);
        }
        catch (StructureException e) {
            logger.warning(e.getMessage());
        }
        AlternativeAlignment[] aligs = aligner.getAlignments();
        ClusterAltAligs.cluster(aligs);
        this.showAlignment(aligner, aligs);
        this.parent.notifyCalcFinished();
    }

    private void showAlignment(StructurePairAligner alignment, AlternativeAlignment[] aligs) {
        AlternativeAlignmentFrame frame = new AlternativeAlignmentFrame(this.structure1, this.structure2);
        frame.setStructurePairAligner(alignment);
        frame.setAlternativeAlignments(aligs);
        frame.pack();
        frame.setVisible(true);
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void cleanup() {
        this.parent.notifyCalcFinished();
        this.parent = null;
        this.structure1 = null;
        this.structure2 = null;
    }
}

