/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.gui.util;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.gui.util.ChooseAction;
import org.biojava.bio.structure.gui.util.StructurePairSelector;
import org.biojava.bio.structure.io.PDBFileReader;

public class PDBUploadPanel
extends JPanel
implements StructurePairSelector {
    private static final long serialVersionUID = 1L;
    JTextField filePath1;
    JTextField filePath2;
    public static Logger logger = Logger.getLogger("org.biojava");

    public PDBUploadPanel() {
        Box vBox = Box.createVerticalBox();
        this.filePath1 = new JTextField(20);
        this.filePath2 = new JTextField(20);
        JPanel p1 = this.getLocalFilePanel(1, this.filePath1);
        JPanel p2 = this.getLocalFilePanel(2, this.filePath2);
        vBox.add(p1);
        vBox.add(p2);
        this.add(vBox);
    }

    public Structure getStructure1() throws StructureException {
        return this.getStructure(this.filePath1);
    }

    public Structure getStructure2() throws StructureException {
        return this.getStructure(this.filePath2);
    }

    private Structure getStructure(JTextField filePath) throws StructureException {
        PDBFileReader reader = new PDBFileReader();
        String path = filePath.getText();
        File f = new File(path);
        Structure s = null;
        try {
            s = reader.getStructure(f);
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            throw new StructureException(e);
        }
        return s;
    }

    private JPanel getLocalFilePanel(int pos, JTextField filePath) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        JLabel l01 = new JLabel("File " + pos + ":");
        panel.add(l01);
        panel.add(filePath);
        ChooseAction action3 = new ChooseAction(filePath);
        JButton chooser = new JButton(action3);
        panel.add(chooser);
        return panel;
    }
}

