/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.gui.util;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.gui.SequenceDisplay;
import org.biojava.bio.structure.gui.events.AlignmentPositionListener;
import org.biojava.bio.structure.gui.util.AlignedPosition;
import org.biojava.bio.structure.gui.util.CoordManager;

public class SequenceMouseListener
implements MouseListener,
MouseMotionListener {
    boolean selectionLocked;
    boolean dragging;
    int selectionStart;
    int selectionEnd;
    int draggingStart;
    int oldSelectionStart;
    int chainLength;
    CoordManager coordManager;
    static Logger logger = Logger.getLogger("org.biojava");
    SequenceDisplay parent;
    List<AlignmentPositionListener> alignmentPositionListeners;

    public SequenceMouseListener(SequenceDisplay parent) {
        this.parent = parent;
        this.selectionLocked = false;
        this.dragging = false;
        this.selectionStart = -1;
        this.selectionEnd = -1;
        this.oldSelectionStart = -1;
        this.draggingStart = -1;
        this.chainLength = 0;
        this.coordManager = new CoordManager();
        this.alignmentPositionListeners = new ArrayList<AlignmentPositionListener>();
    }

    public void clearListeners() {
        this.alignmentPositionListeners.clear();
    }

    public void addAlignmentPositionListener(AlignmentPositionListener li) {
        this.alignmentPositionListeners.add(li);
    }

    public void mousePressed(MouseEvent event) {
        int pos;
        this.draggingStart = pos = this.getSeqPos(event);
        this.selectionStart = pos;
        this.triggerMouseOverPosition(pos, event.getY());
    }

    private int getSeqPos(MouseEvent e) {
        int x = e.getX();
        float scale = this.parent.getScale();
        this.coordManager.setScale(scale);
        int seqpos = this.coordManager.getSeqPos(x - 2);
        return seqpos;
    }

    public void setChain(Chain c) {
        this.chainLength = c.getAtomLength();
        this.coordManager.setLength(this.chainLength);
    }

    private void setSelectionStart(int start) {
        if (start < 0) {
            start = 0;
        }
        if (start > this.chainLength) {
            start = this.chainLength;
        }
        this.selectionStart = start;
    }

    private void setSelectionEnd(int end) {
        if (end > this.chainLength) {
            end = this.chainLength;
        }
        this.selectionEnd = end;
    }

    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        int pos = this.getSeqPos(e);
        if (pos < 0 || pos > this.chainLength) {
            return;
        }
        if (pos == this.oldSelectionStart) {
            return;
        }
        this.oldSelectionStart = pos;
        if (pos > this.draggingStart) {
            this.selectionStart = this.draggingStart;
            this.selectionEnd = pos;
        } else {
            this.selectionStart = pos;
            this.selectionEnd = this.draggingStart;
        }
    }

    public void mouseMoved(MouseEvent e) {
        int pos;
        if (this.selectionLocked) {
            return;
        }
        this.oldSelectionStart = pos = this.getSeqPos(e);
        this.setSelectionStart(pos);
        this.setSelectionEnd(pos);
        this.triggerMouseOverPosition(pos, e.getY());
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent event) {
        this.draggingStart = -1;
        if (!this.dragging || !this.selectionLocked) {
            // empty if block
        }
        this.dragging = false;
    }

    protected void triggerMouseOverPosition(int pos, int mouseY) {
        if (this.selectionLocked) {
            return;
        }
        List<AlignedPosition> apos = this.parent.getAligMap();
        if (pos > apos.size() - 1) {
            return;
        }
        for (AlignmentPositionListener li : this.alignmentPositionListeners) {
            li.mouseOverPosition(apos.get(pos));
        }
    }
}

