/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.StructureIOFile;
import org.biojava.bio.structure.io.mmcif.SimpleMMcifConsumer;
import org.biojava.bio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.utils.io.InputStreamProvider;

public class MMCIFFileReader
implements StructureIOFile {
    String path = "";
    List<String> extensions = new ArrayList<String>();
    boolean autoFetch;

    public static void main(String[] args) {
        String filename = "/Users/andreas/WORK/PDB/mmcif_files/a9/2a9w.cif.gz";
        MMCIFFileReader reader = new MMCIFFileReader();
        reader.setAutoFetch(true);
        try {
            Structure struc = reader.getStructure(filename);
            System.out.println(struc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MMCIFFileReader() {
        this.extensions.add(".cif");
        this.extensions.add(".mmcif");
        this.extensions.add(".cif.gz");
        this.extensions.add(".mmcif.gz");
        this.autoFetch = false;
    }

    public void addExtension(String ext) {
        this.extensions.add(ext);
    }

    public void clearExtensions() {
        this.extensions.clear();
    }

    public Structure getStructure(String filename) throws IOException {
        File f = new File(filename);
        return this.getStructure(f);
    }

    public Structure getStructure(File filename) throws IOException {
        InputStreamProvider isp = new InputStreamProvider();
        InputStream inStream = isp.getInputStream(filename);
        return this.parseFromInputStream(inStream);
    }

    private Structure parseFromInputStream(InputStream inStream) throws IOException {
        SimpleMMcifParser parser = new SimpleMMcifParser();
        SimpleMMcifConsumer consumer = new SimpleMMcifConsumer();
        parser.addMMcifConsumer(consumer);
        parser.parse(new BufferedReader(new InputStreamReader(inStream)));
        Structure cifStructure = consumer.getStructure();
        return cifStructure;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public Structure getStructureById(String pdbId) throws IOException {
        InputStream inStream = this.getInputStream(pdbId);
        return this.parseFromInputStream(inStream);
    }

    private InputStream getInputStream(String pdbId) throws IOException {
        InputStream inputStream = null;
        String pdbFile = null;
        File f = null;
        String fpath = this.path + "/" + pdbId;
        String[] paths = new String[]{fpath};
        block0: for (int p = 0; p < paths.length; ++p) {
            String testpath = paths[p];
            for (int i = 0; i < this.extensions.size(); ++i) {
                String ex = this.extensions.get(i);
                f = new File(testpath + ex);
                if (f.exists()) {
                    pdbFile = testpath + ex;
                    InputStreamProvider isp = new InputStreamProvider();
                    inputStream = isp.getInputStream(pdbFile);
                    continue block0;
                }
                if (pdbFile != null) continue block0;
            }
        }
        if (pdbFile == null) {
            if (this.autoFetch) {
                return this.downloadAndGetInputStream(pdbId);
            }
            String message = "no structure with PDB code " + pdbId + " found!";
            throw new IOException(message);
        }
        return inputStream;
    }

    private InputStream downloadAndGetInputStream(String pdbId) throws IOException {
        File tmp = this.downloadPDB(pdbId);
        if (tmp != null) {
            InputStreamProvider prov = new InputStreamProvider();
            return prov.getInputStream(tmp);
        }
        throw new IOException("could not find PDB " + pdbId + " in file system and also could not download");
    }

    private File downloadPDB(String pdbId) {
        File tempFile = new File(this.path + "/" + pdbId + ".cif.gz");
        File pdbHome = new File(this.path);
        if (!pdbHome.canWrite()) {
            System.err.println("can not write to " + pdbHome);
            return null;
        }
        String ftp = String.format("ftp://ftp.wwpdb.org/pub/pdb/data/structures/all/mmCIF/%s.cif.gz", pdbId.toLowerCase());
        System.out.println("Fetching " + ftp);
        try {
            String line;
            URL url = new URL(ftp);
            InputStream conn = url.openStream();
            System.out.println("writing to " + tempFile);
            FileOutputStream outPut = new FileOutputStream(tempFile);
            GZIPOutputStream gzOutPut = new GZIPOutputStream(outPut);
            PrintWriter pw = new PrintWriter(gzOutPut);
            BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(new GZIPInputStream(conn)));
            while ((line = fileBuffer.readLine()) != null) {
                pw.println(line);
            }
            pw.flush();
            pw.close();
            outPut.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return tempFile;
    }

    public boolean isAutoFetch() {
        return this.autoFetch;
    }

    public void setAutoFetch(boolean autoFetch) {
        this.autoFetch = autoFetch;
    }
}

