/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.mmcif;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.biojava.bio.structure.AminoAcidImpl;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.DBRef;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.HetatomImpl;
import org.biojava.bio.structure.NucleotideImpl;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.io.PDBParseException;
import org.biojava.bio.structure.io.SeqRes2AtomAligner;
import org.biojava.bio.structure.io.mmcif.MMcifConsumer;
import org.biojava.bio.structure.io.mmcif.model.AtomSite;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;
import org.biojava.bio.structure.io.mmcif.model.DatabasePDBremark;
import org.biojava.bio.structure.io.mmcif.model.DatabasePDBrev;
import org.biojava.bio.structure.io.mmcif.model.Entity;
import org.biojava.bio.structure.io.mmcif.model.EntityPolySeq;
import org.biojava.bio.structure.io.mmcif.model.Exptl;
import org.biojava.bio.structure.io.mmcif.model.PdbxEntityNonPoly;
import org.biojava.bio.structure.io.mmcif.model.PdbxNonPolyScheme;
import org.biojava.bio.structure.io.mmcif.model.PdbxPolySeqScheme;
import org.biojava.bio.structure.io.mmcif.model.Refine;
import org.biojava.bio.structure.io.mmcif.model.Struct;
import org.biojava.bio.structure.io.mmcif.model.StructAsym;
import org.biojava.bio.structure.io.mmcif.model.StructKeywords;
import org.biojava.bio.structure.io.mmcif.model.StructRef;
import org.biojava.bio.structure.io.mmcif.model.StructRefSeq;
import org.biojava.bio.symbol.IllegalSymbolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMMcifConsumer
implements MMcifConsumer {
    boolean DEBUG = false;
    Structure structure;
    Chain current_chain;
    Group current_group;
    int atomCount;
    boolean parseCAOnly;
    boolean alignSeqRes;
    List<Chain> current_model;
    List<Entity> entities;
    List<StructRef> strucRefs;
    List<Chain> seqResChains;
    List<Chain> entityChains;
    List<StructAsym> structAsyms;
    Map<String, String> asymStrandId;
    String current_nmr_model;
    public static Logger logger = Logger.getLogger("org.biojava.bio.structure");

    public SimpleMMcifConsumer() {
        this.documentStart();
        this.alignSeqRes = true;
        this.parseCAOnly = false;
    }

    public boolean isParseCAOnly() {
        return this.parseCAOnly;
    }

    public void setParseCAOnly(boolean parseCAOnly) {
        this.parseCAOnly = parseCAOnly;
    }

    @Override
    public void newEntity(Entity entity) {
        if (this.DEBUG) {
            System.out.println(entity);
        }
        this.entities.add(entity);
    }

    @Override
    public void newStructAsym(StructAsym sasym) {
        this.structAsyms.add(sasym);
    }

    private Entity getEntity(String entity_id) {
        for (Entity e : this.entities) {
            if (!e.getId().equals(entity_id)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void newStructKeywords(StructKeywords kw) {
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        header.setDescription(kw.getPdbx_keywords());
        header.setClassification(kw.getPdbx_keywords());
        Map<String, Object> h = this.structure.getHeader();
        h.put("classification", kw.getPdbx_keywords());
    }

    @Override
    public void setStruct(Struct struct) {
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        header.setTitle(struct.getTitle());
        header.setIdCode(struct.getEntry_id());
        Map<String, Object> h = this.structure.getHeader();
        h.put("title", struct.getTitle());
        this.structure.setPDBHeader(header);
        this.structure.setPDBCode(struct.getEntry_id());
    }

    private Group getNewGroup(String recordName, Character aminoCode1, long seq_id) {
        HetatomImpl group;
        if (recordName.equals("ATOM")) {
            if (aminoCode1 == null) {
                NucleotideImpl nu;
                group = nu = new NucleotideImpl();
                nu.setId(seq_id);
            } else if (aminoCode1 == StructureTools.UNKNOWN_GROUP_LABEL) {
                HetatomImpl h = new HetatomImpl();
                h.setId(seq_id);
                group = h;
            } else {
                AminoAcidImpl aa = new AminoAcidImpl();
                aa.setAminoType(aminoCode1);
                aa.setId(seq_id);
                group = aa;
            }
        } else {
            HetatomImpl h = new HetatomImpl();
            h.setId(seq_id);
            group = h;
        }
        return group;
    }

    private Chain isKnownChain(String chainID, List<Chain> chains) {
        for (int i = 0; i < chains.size(); ++i) {
            Chain testchain = chains.get(i);
            if (!chainID.equals(testchain.getName())) continue;
            return testchain;
        }
        return null;
    }

    private String fixFullAtomName(String name) {
        if (name.equals("N")) {
            return " N  ";
        }
        if (name.equals("CA")) {
            return " CA ";
        }
        if (name.equals("C")) {
            return " C  ";
        }
        if (name.equals("O")) {
            return " O  ";
        }
        if (name.equals("CB")) {
            return " CB ";
        }
        if (name.equals("CG")) {
            return " CG ";
        }
        if (name.length() == 2) {
            return " " + name + " ";
        }
        if (name.length() == 1) {
            return " " + name + "  ";
        }
        if (name.length() == 3) {
            return " " + name;
        }
        return name;
    }

    @Override
    public void newAtomSite(AtomSite atom) {
        ++this.atomCount;
        String fullname = this.fixFullAtomName(atom.getLabel_atom_id());
        if (this.parseCAOnly && !fullname.equals(" CA ")) {
            --this.atomCount;
            return;
        }
        String chain_id = atom.getLabel_asym_id();
        long seq_id = -1L;
        try {
            seq_id = Long.parseLong(atom.getLabel_seq_id());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String nmrModel = atom.getPdbx_PDB_model_num();
        String recordName = atom.getGroup_PDB();
        String residueNumber = atom.getAuth_seq_id();
        String insCode = atom.getPdbx_PDB_ins_code();
        if (!insCode.equals("?")) {
            residueNumber = residueNumber + insCode;
        }
        String groupCode3 = atom.getLabel_comp_id();
        Character aminoCode1 = null;
        if (recordName.equals("ATOM")) {
            aminoCode1 = StructureTools.get1LetterCode(groupCode3);
        }
        try {
            if (this.current_nmr_model == null) {
                this.current_nmr_model = nmrModel;
            }
            if (!this.current_nmr_model.equals(nmrModel)) {
                this.current_nmr_model = nmrModel;
                if (this.current_chain != null) {
                    this.current_chain.addGroup(this.current_group);
                }
                this.structure.setNmr(true);
                this.structure.addModel(this.current_model);
                this.current_model = new ArrayList<Chain>();
                this.current_chain = null;
                this.current_group = null;
            }
            if (this.current_chain == null) {
                this.current_chain = new ChainImpl();
                this.current_chain.setName(chain_id);
                this.current_model.add(this.current_chain);
            }
            if (this.current_group == null) {
                this.current_group = this.getNewGroup(recordName, aminoCode1, seq_id);
                this.current_group.setPDBCode(residueNumber);
                this.current_group.setPDBName(groupCode3);
            }
            if (!chain_id.equals(this.current_chain.getName())) {
                this.current_chain.addGroup(this.current_group);
                Chain testchain = this.isKnownChain(this.current_chain.getName(), this.current_model);
                if (testchain == null) {
                    this.current_model.add(this.current_chain);
                }
                if ((testchain = this.isKnownChain(chain_id, this.current_model)) != null) {
                    this.current_chain = (ChainImpl)testchain;
                } else {
                    this.current_chain = new ChainImpl();
                    this.current_chain.setName(chain_id);
                }
                this.current_group = this.getNewGroup(recordName, aminoCode1, seq_id);
                this.current_group.setPDBCode(residueNumber);
                this.current_group.setPDBName(groupCode3);
            }
            if (!residueNumber.equals(this.current_group.getPDBCode())) {
                this.current_chain.addGroup(this.current_group);
                this.current_group = this.getNewGroup(recordName, aminoCode1, seq_id);
                this.current_group.setPDBCode(residueNumber);
                this.current_group.setPDBName(groupCode3);
            }
            Atom a = this.convertAtom(atom);
            this.current_group.addAtom(a);
        }
        catch (PDBParseException e) {
            logger.warning("could not parse AtomSite record " + atom + " due to: " + e.getMessage());
        }
    }

    private Atom convertAtom(AtomSite atom) {
        AtomImpl a = new AtomImpl();
        a.setPDBserial(Integer.parseInt(atom.getId()));
        a.setName(atom.getLabel_atom_id());
        a.setFullName(this.fixFullAtomName(atom.getLabel_atom_id()));
        double x = Double.parseDouble(atom.getCartn_x());
        double y = Double.parseDouble(atom.getCartn_y());
        double z = Double.parseDouble(atom.getCartn_z());
        a.setX(x);
        a.setY(y);
        a.setZ(z);
        double occupancy = Double.parseDouble(atom.getOccupancy());
        a.setOccupancy(occupancy);
        double temp = Double.parseDouble(atom.getB_iso_or_equiv());
        a.setTempFactor(temp);
        String alt = atom.getLabel_alt_id();
        if (alt != null && alt.length() > 0 && !alt.equals(".")) {
            a.setAltLoc(new Character(alt.charAt(0)));
        } else {
            a.setAltLoc(new Character(' '));
        }
        return a;
    }

    @Override
    public void documentStart() {
        this.structure = new StructureImpl();
        this.current_chain = null;
        this.current_group = null;
        this.current_nmr_model = null;
        this.atomCount = 0;
        this.current_model = new ArrayList<Chain>();
        this.entities = new ArrayList<Entity>();
        this.strucRefs = new ArrayList<StructRef>();
        this.seqResChains = new ArrayList<Chain>();
        this.entityChains = new ArrayList<Chain>();
        this.structAsyms = new ArrayList<StructAsym>();
        this.asymStrandId = new HashMap<String, String>();
    }

    public boolean isAlignSeqRes() {
        return this.alignSeqRes;
    }

    public void setAlignSeqRes(boolean alignSeqRes) {
        this.alignSeqRes = alignSeqRes;
    }

    @Override
    public void documentEnd() {
        if (this.current_chain != null) {
            this.current_chain.addGroup(this.current_group);
            if (this.isKnownChain(this.current_chain.getName(), this.current_model) == null) {
                this.current_model.add(this.current_chain);
            }
        }
        this.structure.addModel(this.current_model);
        for (StructAsym asym : this.structAsyms) {
            if (this.DEBUG) {
                System.out.println("entity " + asym.getEntity_id() + " matches asym id:" + asym.getId());
            }
            Chain s = this.getEntityChain(asym.getEntity_id());
            Chain seqres = (Chain)s.clone();
            seqres.setName(asym.getId());
            this.seqResChains.add(seqres);
        }
        if (this.alignSeqRes) {
            SeqRes2AtomAligner aligner = new SeqRes2AtomAligner();
            aligner.align(this.structure, this.seqResChains);
        }
        Set<String> asymIds = this.asymStrandId.keySet();
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            List<Chain> model = this.structure.getModel(i);
            block2: for (Chain chain : model) {
                for (String asym : asymIds) {
                    if (!chain.getName().equals(asym)) continue;
                    if (this.DEBUG) {
                        System.out.println("renaming " + asym + " to : " + this.asymStrandId.get(asym));
                    }
                    chain.setName(this.asymStrandId.get(asym));
                    continue block2;
                }
            }
        }
    }

    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public void newDatabasePDBrev(DatabasePDBrev dbrev) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        PDBHeader header = this.structure.getPDBHeader();
        Map<String, Object> h = this.structure.getHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        if (dbrev.getNum().equals("1")) {
            try {
                String date = dbrev.getDate_original();
                Date dep = dateFormat.parse(date);
                header.setDepDate(dep);
                h.put("depDate", date);
                Date mod = dateFormat.parse(dbrev.getDate());
                header.setModDate(mod);
                h.put("revDate", dbrev.getDate());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Date mod = dateFormat.parse(dbrev.getDate());
                header.setModDate(mod);
                h.put("revDate", dbrev.getDate());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        this.structure.setPDBHeader(header);
    }

    @Override
    public void newDatabasePDBremark(DatabasePDBremark remark) {
        String line;
        int i;
        String id = remark.getId();
        if (id.equals("2") && (i = (line = remark.getText()).indexOf("ANGSTROM")) > 5) {
            String resolution = line.substring(i - 5, i).trim();
            float res = 99.0f;
            try {
                res = Float.parseFloat(resolution);
            }
            catch (NumberFormatException e) {
                System.err.println(e.getMessage());
                System.err.println("could not parse resolution from line and ignoring it " + line);
                return;
            }
            Map<String, Object> header = this.structure.getHeader();
            header.put("resolution", new Float(res));
            this.structure.setHeader(header);
            PDBHeader pdbHeader = this.structure.getPDBHeader();
            pdbHeader.setResolution(res);
        }
    }

    @Override
    public void newRefine(Refine r) {
        PDBHeader pdbHeader = this.structure.getPDBHeader();
        try {
            pdbHeader.setResolution(Float.parseFloat(r.getLs_d_res_high()));
        }
        catch (NumberFormatException e) {
            logger.warning("could not parse resolution from " + r.getLs_d_res_high() + " " + e.getMessage());
        }
        Map<String, Object> header = this.structure.getHeader();
        header.put("resolution", Float.valueOf(pdbHeader.getResolution()));
    }

    @Override
    public void newExptl(Exptl exptl) {
        PDBHeader pdbHeader = this.structure.getPDBHeader();
        String method = exptl.getMethod();
        String old = pdbHeader.getTechnique();
        if (old != null && !old.equals("")) {
            method = old + "; " + method;
        }
        pdbHeader.setTechnique(method);
        Map<String, Object> header = this.structure.getHeader();
        header.put("technique", method);
    }

    @Override
    public void newStructRef(StructRef sref) {
        if (this.DEBUG) {
            System.out.println(sref);
        }
        this.strucRefs.add(sref);
    }

    private StructRef getStructRef(String ref_id) {
        for (StructRef structRef : this.strucRefs) {
            if (!structRef.getId().equals(ref_id)) continue;
            return structRef;
        }
        return null;
    }

    @Override
    public void newStructRefSeq(StructRefSeq sref) {
        DBRef r = new DBRef();
        r.setIdCode(sref.getPdbx_PDB_id_code());
        r.setDbAccession(sref.getPdbx_db_accession());
        r.setDbIdCode(sref.getPdbx_db_accession());
        r.setChainId(new Character(sref.getPdbx_strand_id().charAt(0)));
        StructRef structRef = this.getStructRef(sref.getRef_id());
        if (structRef == null) {
            logger.warning("could not find StructRef " + sref.getRef_id() + " for StructRefSeq " + sref);
        } else {
            r.setDatabase(structRef.getDb_name());
            r.setDbIdCode(structRef.getDb_code());
        }
        int seqbegin = Integer.parseInt(sref.getPdbx_auth_seq_align_beg());
        int seqend = Integer.parseInt(sref.getPdbx_auth_seq_align_end());
        Character begin_ins_code = new Character(sref.getPdbx_seq_align_beg_ins_code().charAt(0));
        Character end_ins_code = new Character(sref.getPdbx_seq_align_end_ins_code().charAt(0));
        if (begin_ins_code.charValue() == '?') {
            begin_ins_code = Character.valueOf(' ');
        }
        if (end_ins_code.charValue() == '?') {
            end_ins_code = Character.valueOf(' ');
        }
        r.setSeqBegin(seqbegin);
        r.setInsertBegin(begin_ins_code.charValue());
        r.setSeqEnd(seqend);
        r.setInsertEnd(end_ins_code.charValue());
        int dbseqbegin = Integer.parseInt(sref.getDb_align_beg());
        int dbseqend = Integer.parseInt(sref.getDb_align_end());
        Character db_begin_in_code = new Character(sref.getPdbx_db_align_beg_ins_code().charAt(0));
        Character db_end_in_code = new Character(sref.getPdbx_db_align_end_ins_code().charAt(0));
        if (db_begin_in_code.charValue() == '?') {
            db_begin_in_code = Character.valueOf(' ');
        }
        if (db_end_in_code.charValue() == '?') {
            db_end_in_code = Character.valueOf(' ');
        }
        r.setDbSeqBegin(dbseqbegin);
        r.setIdbnsBegin(db_begin_in_code.charValue());
        r.setDbSeqEnd(dbseqend);
        r.setIdbnsEnd(db_end_in_code.charValue());
        List<DBRef> dbrefs = this.structure.getDBRefs();
        if (dbrefs == null) {
            dbrefs = new ArrayList<DBRef>();
        }
        dbrefs.add(r);
        if (this.DEBUG) {
            System.out.println(r.toPDB());
        }
        this.structure.setDBRefs(dbrefs);
    }

    private Chain getChainFromList(List<Chain> chains, String name) {
        for (Chain chain : chains) {
            if (!chain.getName().equals(name)) continue;
            return chain;
        }
        ChainImpl chain = new ChainImpl();
        chain.setName(name);
        chains.add(chain);
        return chain;
    }

    private Chain getEntityChain(String entity_id) {
        return this.getChainFromList(this.entityChains, entity_id);
    }

    @Override
    public void newEntityPolySeq(EntityPolySeq epolseq) {
        Entity e = this.getEntity(epolseq.getEntity_id());
        if (e == null) {
            System.err.println("could not find entity " + epolseq.getEntity_id() + ". Can not match sequence to it.");
            return;
        }
        Chain entityChain = this.getEntityChain(epolseq.getEntity_id());
        AminoAcidImpl g = new AminoAcidImpl();
        g.setRecordType("SEQRES");
        try {
            g.setPDBName(epolseq.getMon_id());
            Character code1 = StructureTools.convert_3code_1code(epolseq.getMon_id());
            g.setAminoType(code1);
            g.setPDBCode(epolseq.getNum());
            entityChain.addGroup(g);
        }
        catch (PDBParseException ex) {
            if (StructureTools.isNucleotide(epolseq.getMon_id())) {
                NucleotideImpl n = new NucleotideImpl();
                n.setPDBCode(epolseq.getNum());
                entityChain.addGroup(n);
            } else {
                logger.warning(ex.getMessage());
            }
        }
        catch (IllegalSymbolException ex) {
            logger.warning(ex.getMessage());
        }
    }

    private List<Chain> getChainsFromAllModels(String chainId) {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            List<Chain> model = this.structure.getModel(i);
            for (Chain c : model) {
                if (!c.getName().equals(chainId)) continue;
                chains.add(c);
            }
        }
        return chains;
    }

    private void replaceGroupSeqPos(PdbxPolySeqScheme ppss) {
        if (ppss.getAuth_seq_num().equals("?")) {
            return;
        }
        List<Chain> matchinChains = this.getChainsFromAllModels(ppss.getAsym_id());
        long sid = Long.parseLong(ppss.getSeq_id());
        for (Chain c : matchinChains) {
            Group target = null;
            for (Group g : c.getAtomGroups()) {
                NucleotideImpl n;
                if (g instanceof AminoAcidImpl) {
                    AminoAcidImpl aa = (AminoAcidImpl)g;
                    if (aa.getId() != sid) continue;
                    target = g;
                    break;
                }
                if (!(g instanceof NucleotideImpl) || (n = (NucleotideImpl)g).getId() != sid) continue;
                target = g;
                break;
            }
            if (target == null) {
                logger.info("could not find group at seq. position " + ppss.getSeq_id() + " in internal chain. " + ppss);
                continue;
            }
            if (!target.getPDBName().equals(ppss.getMon_id())) {
                logger.info("could not match PdbxPolySeqScheme to chain:" + ppss);
                continue;
            }
            String pdbResNum = ppss.getAuth_seq_num();
            String insCode = ppss.getPdb_ins_code();
            if (insCode != null && !insCode.equals(".")) {
                pdbResNum = pdbResNum + insCode;
            }
            target.setPDBCode(pdbResNum);
        }
    }

    @Override
    public void newPdbxPolySeqScheme(PdbxPolySeqScheme ppss) {
        this.replaceGroupSeqPos(ppss);
        if (this.asymStrandId.containsKey(ppss.getAsym_id())) {
            return;
        }
        if (ppss.getPdb_strand_id() == null) {
            this.asymStrandId.put(ppss.getAsym_id(), ppss.getAuth_mon_id());
            return;
        }
        this.asymStrandId.put(ppss.getAsym_id(), ppss.getPdb_strand_id());
    }

    @Override
    public void newPdbxNonPolyScheme(PdbxNonPolyScheme ppss) {
        if (this.asymStrandId.containsKey(ppss.getAsym_id())) {
            return;
        }
        if (ppss.getPdb_strand_id() == null) {
            this.asymStrandId.put(ppss.getAsym_id(), ppss.getAsym_id());
            return;
        }
        this.asymStrandId.put(ppss.getAsym_id(), ppss.getPdb_strand_id());
    }

    @Override
    public void newPdbxEntityNonPoly(PdbxEntityNonPoly pen) {
    }

    @Override
    public void newChemComp(ChemComp c) {
    }

    @Override
    public void newGenericData(String category, List<String> loopFields, List<String> lineData) {
        if (this.DEBUG) {
            System.err.println("unhandled category so far: " + category);
        }
    }
}

