/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.db.biosql;

import java.lang.reflect.Method;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SymbolList;
import org.biojavax.CrossRef;
import org.biojavax.CrossReferenceResolver;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.seq.InfinitelyAmbiguousSymbolList;
import org.biojavax.bio.seq.RichSequence;

public class BioSQLCrossReferenceResolver
implements CrossReferenceResolver {
    private Object session;
    private Method createQuery;
    private Method setParameter;
    private Method uniqueResult;

    public BioSQLCrossReferenceResolver(Object session) {
        try {
            Class<?> hibernateSession = session.getClass();
            Class<?> realHibernateSession = Class.forName("org.hibernate.Session");
            if (!realHibernateSession.isAssignableFrom(hibernateSession)) {
                throw new IllegalArgumentException("Parameter must be a org.hibernate.Session object");
            }
            this.session = session;
            this.createQuery = hibernateSession.getMethod("createQuery", String.class);
            Class<?> hibernateQuery = Class.forName("org.hibernate.Query");
            this.setParameter = hibernateQuery.getMethod("setParameter", Integer.TYPE, Object.class);
            this.uniqueResult = hibernateQuery.getMethod("uniqueResult", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public SymbolList getRemoteSymbolList(CrossRef cr, Alphabet a) {
        BioEntry be = this.getRemoteBioEntry(cr);
        if (be instanceof RichSequence) {
            return (RichSequence)be;
        }
        if (!(a instanceof FiniteAlphabet)) {
            throw new IllegalArgumentException("Cannot construct dummy symbol list for a non-finite alphabet");
        }
        return new InfinitelyAmbiguousSymbolList((FiniteAlphabet)a);
    }

    public BioEntry getRemoteBioEntry(CrossRef cr) {
        Namespace ns = (Namespace)RichObjectFactory.getObject(SimpleNamespace.class, new Object[]{cr.getDbname()});
        try {
            String queryText = "from BioEntry where namespace = ? and accession = ? and version = ?";
            Object query = this.createQuery.invoke(this.session, queryText);
            query = this.setParameter.invoke(query, new Integer(0), ns);
            query = this.setParameter.invoke(query, new Integer(1), cr.getAccession());
            query = this.setParameter.invoke(query, new Integer(2), new Integer(cr.getVersion()));
            Object result = this.uniqueResult.invoke(query, (Object[])null);
            return (BioEntry)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to locate remote cross reference " + cr, e);
        }
    }
}

