/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.db.biosql;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.bio.seq.DummyRichSequenceHandler;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.SimpleRichSequence;

public class BioSQLRichSequenceHandler
extends DummyRichSequenceHandler {
    private Object session;
    private Method createQuery;
    private Method setParameter;
    private Method uniqueResult;

    public BioSQLRichSequenceHandler(Object session) {
        try {
            Class<?> hibernateSession = session.getClass();
            Class<?> realHibernateSession = Class.forName("org.hibernate.Session");
            if (!realHibernateSession.isAssignableFrom(hibernateSession)) {
                throw new IllegalArgumentException("Parameter must be a org.hibernate.Session object");
            }
            this.session = session;
            this.createQuery = hibernateSession.getMethod("createQuery", String.class);
            Class<?> hibernateQuery = Class.forName("org.hibernate.Query");
            this.setParameter = hibernateQuery.getMethod("setParameter", Integer.TYPE, Object.class);
            this.uniqueResult = hibernateQuery.getMethod("uniqueResult", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void edit(RichSequence seq, Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
        if (seq instanceof SimpleRichSequence) {
            super.edit(seq, edit);
        }
        throw new ChangeVetoException("Cannot modify this sequence. Convert to a SimpleRichSequence first.");
    }

    public Symbol symbolAt(RichSequence seq, int index) throws IndexOutOfBoundsException {
        if (seq instanceof SimpleRichSequence) {
            return super.symbolAt(seq, index);
        }
        return this.subList(seq, index, index).symbolAt(1);
    }

    public List toList(RichSequence seq) {
        if (seq instanceof SimpleRichSequence) {
            return super.toList(seq);
        }
        if (seq.length() == 0) {
            return new ArrayList();
        }
        return this.subList(seq, 1, seq.length()).toList();
    }

    public String subStr(RichSequence seq, int start, int end) throws IndexOutOfBoundsException {
        if (seq instanceof SimpleRichSequence) {
            return super.subStr(seq, start, end);
        }
        if (seq.length() == 0) {
            return "";
        }
        if (seq.getCircular()) {
            StringBuffer result = new StringBuffer();
            int[] modLocation = RichLocation.Tools.modulateCircularLocation(start, end, seq.length());
            int modStart = modLocation[0];
            int modEnd = modLocation[1];
            int modLength = modEnd - modStart + 1;
            int seqLength = seq.length();
            if (modStart == 0) {
                modStart = seqLength;
            }
            if (modEnd == 0) {
                modEnd = seqLength;
            }
            if (modEnd > seqLength) {
                int remaining = modLength;
                int chunkSize = seqLength - modStart + 1;
                result.append(this.seqSubString(seq, modStart, seqLength));
                remaining -= chunkSize;
                while (remaining > seqLength) {
                    chunkSize = seqLength;
                    result.append(this.seqSubString(seq, 1, seqLength));
                    remaining -= chunkSize;
                }
                chunkSize = remaining;
                result.append(this.seqSubString(seq, 1, chunkSize));
            } else {
                result.append(this.seqSubString(seq, modStart, modEnd));
            }
            return result.toString();
        }
        return this.seqSubString(seq, start, end);
    }

    public SymbolList subList(RichSequence seq, int start, int end) throws IndexOutOfBoundsException {
        if (seq instanceof SimpleRichSequence) {
            return super.subList(seq, start, end);
        }
        return this.convertToSymbolList(this.subStr(seq, start, end), seq.getAlphabet());
    }

    public String seqString(RichSequence seq) {
        if (seq instanceof SimpleRichSequence) {
            return super.seqString(seq);
        }
        try {
            String queryText = "select s.stringSequence from Sequence as s where s.namespace = ? and s.name = ?";
            Object query = this.createQuery.invoke(this.session, queryText);
            query = this.setParameter.invoke(query, new Integer(0), seq.getNamespace());
            query = this.setParameter.invoke(query, new Integer(1), seq.getName());
            Object result = this.uniqueResult.invoke(query, (Object[])null);
            return (String)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to locate full sequence " + seq, e);
        }
    }

    private String seqSubString(RichSequence seq, int start, int end) {
        try {
            String queryText = "select substring(s.stringSequence,?,?) from Sequence as s where s.namespace = ? and s.name = ?";
            Object query = this.createQuery.invoke(this.session, queryText);
            query = this.setParameter.invoke(query, new Integer(0), new Integer(start));
            query = this.setParameter.invoke(query, new Integer(1), new Integer(end - start + 1));
            query = this.setParameter.invoke(query, new Integer(2), seq.getNamespace());
            query = this.setParameter.invoke(query, new Integer(3), seq.getName());
            Object result = this.uniqueResult.invoke(query, (Object[])null);
            return (String)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to locate full sequence " + seq, e);
        }
    }

    public Iterator iterator(RichSequence seq) {
        if (seq instanceof SimpleRichSequence) {
            return super.iterator(seq);
        }
        return this.toList(seq).iterator();
    }

    private SymbolList convertToSymbolList(String seq, Alphabet alpha) {
        try {
            return new SimpleSymbolList(alpha.getTokenization("token"), seq);
        }
        catch (IllegalSymbolException e) {
            throw new BioError("Found bad symbols in sequence string!", e);
        }
        catch (BioException e) {
            throw new BioError("Found general exception in sequence string!", e);
        }
    }
}

