/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.NucleotideTools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNamespace;
import org.biojavax.SimpleNote;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequenceIterator;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichLocation;
import org.biojavax.bio.seq.SimpleRichSequence;
import org.biojavax.bio.seq.io.EMBLFormat;
import org.biojavax.bio.seq.io.EMBLxmlFormat;
import org.biojavax.bio.seq.io.FastaFormat;
import org.biojavax.bio.seq.io.FastaHeader;
import org.biojavax.bio.seq.io.GenbankFormat;
import org.biojavax.bio.seq.io.HashedFastaIterator;
import org.biojavax.bio.seq.io.INSDseqFormat;
import org.biojavax.bio.seq.io.RichSequenceBuilderFactory;
import org.biojavax.bio.seq.io.RichSequenceFormat;
import org.biojavax.bio.seq.io.RichStreamReader;
import org.biojavax.bio.seq.io.RichStreamWriter;
import org.biojavax.bio.seq.io.UniProtFormat;
import org.biojavax.bio.seq.io.UniProtXMLFormat;
import org.biojavax.ontology.ComparableTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RichSequence
extends BioEntry,
Sequence {
    public static final ChangeType SYMLISTVERSION = new ChangeType("This sequences's symbollist version has changed", "org.biojavax.bio.seq.RichSequence", "SYMLISTVERSION");
    public static final ChangeType CIRCULAR = new ChangeType("This sequences's circularity has changed", "org.biojavax.bio.seq.RichSequence", "CIRCULAR");

    public Double getSeqVersion();

    public void setSeqVersion(Double var1) throws ChangeVetoException;

    public Set<Feature> getFeatureSet();

    public void setFeatureSet(Set<Feature> var1) throws ChangeVetoException;

    public void setCircular(boolean var1) throws ChangeVetoException;

    public boolean getCircular();

    public SymbolList getInternalSymbolList();

    public static final class IOTools {
        private static RichSequenceBuilderFactory factory = RichSequenceBuilderFactory.FACTORY;
        private static List<Class> formatClasses = new ArrayList<Class>();

        private IOTools() {
        }

        public static void registerFormat(Class formatClass) {
            Object o;
            try {
                o = formatClass.newInstance();
            }
            catch (Exception e) {
                throw new BioError(e);
            }
            if (!(o instanceof RichSequenceFormat)) {
                throw new BioError("Class " + formatClass + " is not an implementation of RichSequenceFormat!");
            }
            formatClasses.add(formatClass);
        }

        public static RichSequenceIterator readStream(BufferedInputStream stream, RichSequenceBuilderFactory seqFactory, Namespace ns) throws IOException {
            for (Class formatClass : formatClasses) {
                RichSequenceFormat format;
                try {
                    format = (RichSequenceFormat)formatClass.newInstance();
                }
                catch (Exception e) {
                    throw new BioError(e);
                }
                if (!format.canRead(stream)) continue;
                SymbolTokenization sTok = format.guessSymbolTokenization(stream);
                BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                return new RichStreamReader(br, format, sTok, seqFactory, ns);
            }
            throw new IOException("Could not recognise format of stream.");
        }

        public static RichSequenceIterator readStream(BufferedInputStream stream, Namespace ns) throws IOException {
            return IOTools.readStream(stream, factory, ns);
        }

        public static RichSequenceIterator readFile(File file, RichSequenceBuilderFactory seqFactory, Namespace ns) throws IOException {
            for (Class formatClass : formatClasses) {
                RichSequenceFormat format;
                try {
                    format = (RichSequenceFormat)formatClass.newInstance();
                }
                catch (Exception e) {
                    throw new BioError(e);
                }
                if (!format.canRead(file)) continue;
                SymbolTokenization sTok = format.guessSymbolTokenization(file);
                BufferedReader br = new BufferedReader(new FileReader(file));
                return new RichStreamReader(br, format, sTok, seqFactory, ns);
            }
            throw new IOException("Could not recognise format of file: " + file.getName());
        }

        public static RichSequenceIterator readFile(File file, Namespace ns) throws IOException {
            return IOTools.readFile(file, factory, ns);
        }

        public static RichSequenceIterator readFasta(BufferedReader br, SymbolTokenization sTok, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new FastaFormat(), sTok, factory, ns);
        }

        public static RichSequenceIterator readFasta(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new FastaFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readFastaDNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new FastaFormat(), IOTools.getDNAParser(), factory, ns);
        }

        public static RichSequenceIterator readHashedFastaDNA(BufferedInputStream is, Namespace ns) throws BioException {
            Alphabet alpha = AlphabetManager.alphabetForName("DNA");
            return new HashedFastaIterator(is, alpha, ns);
        }

        public static RichSequenceIterator readFastaRNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new FastaFormat(), IOTools.getRNAParser(), factory, ns);
        }

        public static RichSequenceIterator readFastaProtein(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new FastaFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readGenbank(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new GenbankFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readGenbankDNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new GenbankFormat(), IOTools.getDNAParser(), factory, ns);
        }

        public static RichSequenceIterator readGenbankRNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new GenbankFormat(), IOTools.getRNAParser(), factory, ns);
        }

        public static RichSequenceIterator readGenbankProtein(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new GenbankFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readINSDseq(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new INSDseqFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readINSDseqDNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new INSDseqFormat(), IOTools.getDNAParser(), factory, ns);
        }

        public static RichSequenceIterator readINSDseqRNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new INSDseqFormat(), IOTools.getRNAParser(), factory, ns);
        }

        public static RichSequenceIterator readINSDseqProtein(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new INSDseqFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBLxml(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLxmlFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readEMBLxmlDNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLxmlFormat(), IOTools.getDNAParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBLxmlRNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLxmlFormat(), IOTools.getRNAParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBLxmlProtein(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLxmlFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBL(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readEMBLDNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLFormat(), IOTools.getDNAParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBLRNA(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLFormat(), IOTools.getRNAParser(), factory, ns);
        }

        public static RichSequenceIterator readEMBLProtein(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new EMBLFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readUniProt(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new UniProtFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readUniProt(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new UniProtFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static RichSequenceIterator readUniProtXML(BufferedReader br, SymbolTokenization sTok, RichSequenceBuilderFactory seqFactory, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new UniProtXMLFormat(), sTok, seqFactory, ns);
        }

        public static RichSequenceIterator readUniProtXML(BufferedReader br, Namespace ns) {
            return new RichStreamReader(br, (RichSequenceFormat)new UniProtXMLFormat(), IOTools.getProteinParser(), factory, ns);
        }

        public static void writeFasta(OutputStream os, SequenceIterator in, Namespace ns, FastaHeader header) throws IOException {
            FastaFormat fastaFormat = new FastaFormat();
            if (header != null) {
                fastaFormat.setHeader(header);
            }
            RichStreamWriter sw = new RichStreamWriter(os, fastaFormat);
            sw.writeStream(in, ns);
        }

        public static void writeFasta(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            IOTools.writeFasta(os, in, ns, null);
        }

        public static void writeFasta(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeFasta(os, new SingleRichSeqIterator(seq), ns, null);
        }

        public static void writeFasta(OutputStream os, Sequence seq, Namespace ns, FastaHeader header) throws IOException {
            IOTools.writeFasta(os, new SingleRichSeqIterator(seq), ns, header);
        }

        public static void writeGenbank(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new GenbankFormat());
            sw.writeStream(in, ns);
        }

        public static void writeGenbank(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeGenbank(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeINSDseq(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new INSDseqFormat());
            sw.writeStream(in, ns);
        }

        public static void writeINSDseq(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeINSDseq(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeEMBLxml(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new EMBLxmlFormat());
            sw.writeStream(in, ns);
        }

        public static void writeEMBLxml(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeEMBLxml(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeEMBL(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new EMBLFormat());
            sw.writeStream(in, ns);
        }

        public static void writeEMBL(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeEMBL(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeUniProt(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new UniProtFormat());
            sw.writeStream(in, ns);
        }

        public static void writeUniProt(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeUniProt(os, new SingleRichSeqIterator(seq), ns);
        }

        public static void writeUniProtXML(OutputStream os, SequenceIterator in, Namespace ns) throws IOException {
            RichStreamWriter sw = new RichStreamWriter(os, new UniProtXMLFormat());
            sw.writeStream(in, ns);
        }

        public static void writeUniProtXML(OutputStream os, Sequence seq, Namespace ns) throws IOException {
            IOTools.writeUniProtXML(os, new SingleRichSeqIterator(seq), ns);
        }

        public static SymbolTokenization getDNAParser() {
            try {
                return DNATools.getDNA().getTokenization("token");
            }
            catch (BioException ex) {
                throw new BioError("Assertion failing: Couldn't get DNA token parser", ex);
            }
        }

        public static SymbolTokenization getRNAParser() {
            try {
                return RNATools.getRNA().getTokenization("token");
            }
            catch (BioException ex) {
                throw new BioError("Assertion failing: Couldn't get RNA token parser", ex);
            }
        }

        public static SymbolTokenization getNucleotideParser() {
            try {
                return NucleotideTools.getNucleotide().getTokenization("token");
            }
            catch (BioException ex) {
                throw new BioError("Assertion failing: Couldn't get nucleotide token parser", ex);
            }
        }

        public static SymbolTokenization getProteinParser() {
            try {
                return ProteinTools.getTAlphabet().getTokenization("token");
            }
            catch (BioException ex) {
                throw new BioError("Assertion failing: Couldn't get PROTEIN token parser", ex);
            }
        }

        public static final class SingleRichSeqIterator
        implements RichSequenceIterator {
            private RichSequence seq;

            public SingleRichSeqIterator(Sequence seq) {
                try {
                    this.seq = seq instanceof RichSequence ? (RichSequence)seq : Tools.enrich(seq);
                }
                catch (ChangeVetoException e) {
                    throw new RuntimeException("Unable to enrich sequence", e);
                }
            }

            public boolean hasNext() {
                return this.seq != null;
            }

            public Sequence nextSequence() {
                return this.nextRichSequence();
            }

            public BioEntry nextBioEntry() {
                return this.nextRichSequence();
            }

            public RichSequence nextRichSequence() {
                RichSequence seq = this.seq;
                this.seq = null;
                return seq;
            }
        }
    }

    public static class Tools {
        private Tools() {
        }

        public static RichSequence createRichSequence(String name, String seqString, Alphabet alpha) throws BioException {
            SimpleSymbolList syms = new SimpleSymbolList(alpha.getTokenization("token"), seqString);
            return Tools.createRichSequence(name, syms);
        }

        public static RichSequence createRichSequence(String namespace, String name, String seqString, Alphabet alpha) throws BioException {
            SimpleSymbolList syms = new SimpleSymbolList(alpha.getTokenization("token"), seqString);
            Namespace ns = (Namespace)RichObjectFactory.getObject(SimpleNamespace.class, new Object[]{namespace});
            return Tools.createRichSequence(ns, name, syms);
        }

        public static RichSequence createRichSequence(Namespace ns, String name, String seqString, Alphabet alpha) throws BioException {
            SimpleSymbolList syms = new SimpleSymbolList(alpha.getTokenization("token"), seqString);
            return Tools.createRichSequence(ns, name, syms);
        }

        public static RichSequence createRichSequence(String name, SymbolList syms) {
            Namespace ns = RichObjectFactory.getDefaultNamespace();
            return Tools.createRichSequence(ns, name, syms);
        }

        public static RichSequence createRichSequence(Namespace ns, String name, SymbolList syms) {
            return new SimpleRichSequence(ns, name, name, 1, syms, new Double(1.0));
        }

        public static RichSequence enrich(Sequence s) throws ChangeVetoException {
            if (s instanceof RichSequence) {
                return (RichSequence)s;
            }
            String name = s.getName();
            SimpleRichSequence rs = new SimpleRichSequence(RichObjectFactory.getDefaultNamespace(), name == null ? "UnknownName" : name, name == null ? "UnknownAccession" : name, 0, s, new Double(0.0));
            Iterator<Feature> i = s.features();
            while (i.hasNext()) {
                Feature f = i.next();
                try {
                    rs.createFeature(f.makeTemplate());
                }
                catch (BioException e) {
                    throw new ChangeVetoException("They hates us!", e);
                }
            }
            for (Feature key : s.getAnnotation().keys()) {
                Object value = s.getAnnotation().getProperty(key);
                rs.getAnnotation().setProperty(key, value);
            }
            return rs;
        }

        public static RichSequence subSequence(RichSequence s, int from, int to, Namespace newNamespace, String newName, String newAccession, String newIdentifier, int newVersion, Double seqVersion) throws IndexOutOfBoundsException {
            SymbolList symList = s.subList(from, to);
            SimpleRichSequence seq = new SimpleRichSequence(newNamespace, newName, newAccession, newVersion, symList, seqVersion);
            SimpleRichLocation subLoc = new SimpleRichLocation((Position)new SimplePosition(from), new SimplePosition(to), 0);
            SimpleRichLocation subLocComplement = new SimpleRichLocation((Position)new SimplePosition(from), new SimplePosition(to), 0, RichLocation.Strand.NEGATIVE_STRAND);
            try {
                Iterator<Feature> i = s.features();
                while (i.hasNext()) {
                    SimplePosition max;
                    SimplePosition min;
                    RichFeature.Template templ;
                    RichFeature f = (RichFeature)i.next();
                    if (f.getStrand().equals(StrandedFeature.POSITIVE)) {
                        if (!subLoc.contains(f.getLocation())) continue;
                        templ = (RichFeature.Template)f.makeTemplate();
                        min = new SimplePosition(templ.location.getMin() - from + 1);
                        max = new SimplePosition(templ.location.getMax() - from + 1);
                        templ.location = new SimpleRichLocation((Position)min, max, 0);
                        seq.createFeature(templ);
                        continue;
                    }
                    if (!subLocComplement.contains(f.getLocation())) continue;
                    templ = (RichFeature.Template)f.makeTemplate();
                    min = new SimplePosition(templ.location.getMin() - from + 1);
                    max = new SimplePosition(templ.location.getMax() - from + 1);
                    templ.location = new SimpleRichLocation((Position)min, max, 0, RichLocation.Strand.NEGATIVE_STRAND);
                    seq.createFeature(templ);
                }
                if (s.getNoteSet() != null) {
                    Set notes = s.getNoteSet();
                    Iterator it = notes.iterator();
                    TreeSet<SimpleNote> ns = new TreeSet<SimpleNote>();
                    while (it.hasNext()) {
                        Note note = (Note)it.next();
                        ns.add(new SimpleNote(note.getTerm(), note.getValue(), note.getRank()));
                    }
                    seq.setNoteSet(ns);
                }
                if (s.getTaxon() != null) {
                    seq.setTaxon(s.getTaxon());
                }
                if (s.getDescription() != null) {
                    seq.setDescription("subsequence (" + from + ":" + to + ") of " + s.getDescription());
                }
                if (s.getDivision() != null) {
                    seq.setDivision(s.getDivision());
                }
            }
            catch (ChangeVetoException ex) {
                throw new BioError(ex);
            }
            catch (BioException ex) {
                throw new BioError(ex);
            }
            return seq;
        }
    }

    public static class Terms {
        public static String SPECIES_KEY = "SPECIES";
        public static String STRAIN_KEY = "STRAIN";
        public static String TISSUE_KEY = "TISSUE";
        public static String TRANSPOSON_KEY = "TRANSPOSON";
        public static String PLASMID_KEY = "PLASMID";
        public static final String PUBMED_KEY = "PUBMED";
        public static final String MEDLINE_KEY = "MEDLINE";
        public static final String DOI_KEY = "DOI";

        public static ComparableTerm getAdditionalAccessionTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("acc");
        }

        public static ComparableTerm getKeywordTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("kw");
        }

        public static ComparableTerm getDateCreatedTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("cdat");
        }

        public static ComparableTerm getDateUpdatedTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("udat");
        }

        public static ComparableTerm getDateAnnotatedTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("adat");
        }

        public static ComparableTerm getRelCreatedTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("crel");
        }

        public static ComparableTerm getRelUpdatedTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("urel");
        }

        public static ComparableTerm getRelAnnotatedTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("arel");
        }

        public static ComparableTerm getMolTypeTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("moltype");
        }

        public static ComparableTerm getStrandedTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("stranded");
        }

        public static ComparableTerm getOrganelleTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("organelle");
        }

        public static ComparableTerm getGeneNameTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("gene_name");
        }

        public static ComparableTerm getGeneSynonymTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("gene_synonym");
        }

        public static ComparableTerm getOrderedLocusNameTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("gene_ordloc");
        }

        public static ComparableTerm getORFNameTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("gene_orf");
        }

        public static ComparableTerm getStrainTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("strain");
        }

        public static ComparableTerm getSpeciesTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("species");
        }

        public static ComparableTerm getTissueTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("tissue");
        }

        public static ComparableTerm getTransposonTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("transposon");
        }

        public static ComparableTerm getPlasmidTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("plasmid");
        }

        public static ComparableTerm getDataClassTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("dataclass");
        }

        public static ComparableTerm getFTIdTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("feature_id");
        }

        public static ComparableTerm getFeatureDescTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("feature_desc");
        }

        public static ComparableTerm getCopyrightTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("copyright");
        }
    }
}

