/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.taxa;

public class SimpleNCBITaxonName
implements Comparable {
    private String nameClass;
    private String name;

    protected SimpleNCBITaxonName() {
    }

    public SimpleNCBITaxonName(String nameClass, String name) {
        if (nameClass == null) {
            throw new IllegalArgumentException("Name class cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.indexOf(10) >= 0) {
            throw new IllegalArgumentException("NCBI taxonomy names cannot embed new lines - at:" + name.indexOf(10) + ", in name: <" + name + ">");
        }
        this.nameClass = nameClass;
        this.name = name;
    }

    public void setNameClass(String nameClass) {
        if (nameClass == null) {
            throw new IllegalArgumentException("Name class cannot be null");
        }
        this.nameClass = nameClass;
    }

    public String getNameClass() {
        return this.nameClass;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleNCBITaxonName)) {
            return false;
        }
        if (this.nameClass == null) {
            return false;
        }
        SimpleNCBITaxonName them = (SimpleNCBITaxonName)o;
        return them.getNameClass().equals(this.nameClass) && them.getName().equals(this.name);
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (this.nameClass == null) {
            return -1;
        }
        SimpleNCBITaxonName them = (SimpleNCBITaxonName)o;
        if (!them.getNameClass().equals(this.nameClass)) {
            return this.nameClass.compareTo(them.getNameClass());
        }
        return this.name.compareTo(them.getName());
    }

    public int hashCode() {
        int code = 17;
        if (this.nameClass == null) {
            return code;
        }
        code = 31 * code + this.name.hashCode();
        code = 31 * code + this.nameClass.hashCode();
        return code;
    }

    public String toString() {
        return this.nameClass + ":" + this.name;
    }
}

